package yangtz.cs.liu.activiti.service;

import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import yangtz.cs.liu.activiti.domain.HistoricActivity;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

public interface IProcessService {

    /**
     * 查询审批历史列表
     *
     * @param processInstanceId
     * @param historicActivity
     * @return
     */
    List<HistoricActivity> selectHistoryList(String processInstanceId, HistoricActivity historicActivity);

    /**
     * 提交申请
     *
     * @param applyUserId 申请人
     * @param businessKey 业务表 id
     * @param key         流程定义 key
     * @param variables   流程变量
     * @return
     */
    ProcessInstance submitApply(String applyUserId, String businessKey, String itemName, String itemConent, String key, Map<String, Object> variables);

    /**
     * 待表列表
     *
     * @param userId
     * @param key
     * @return
     */
    List<Task> findTodoTasks(String userId, String key);


    /**
     * 待办集合
     * @param userId 用户id
     * @param key 流程key
     * @return
     */
    List<Task> findTodoList(String userId, String key);

    /**
     * 查询个人任务
     */
    List<Task> findAssigneeTasks(String userId, String key);



    /**
     * 查询组任务
     *
     * @param userId
     * @param key
     * @return
     */
    List<Task> findCandidateTasks(String userId, String key);

    List<HistoricTaskInstance> findDoneTasks(String userId, String key);

    void complete(String taskId, String instanceId, String itemName, String itemContent, String module, Map<String, Object> variables, HttpServletRequest request);

    /**
     * 委托任务
     *
     * @param taskId
     * @param delegateToUser
     */
    void delegate(String taskId, String fromUser, String delegateToUser);

    void cancelApply(String instanceId, String deleteReason);

    void suspendOrActiveApply(String instanceId, String suspendState);

    String findBusinessKeyByInstanceId(String instanceId);

    /**
     * 办理任务
     *
     * @param taskId
     * @param variables
     */
    void completeTask(String taskId, String instanceId, Map<String, Object> variables);


    /**
     *
     * @author lyric
     * @date 2022/11/18 12:58
     *
     * 公众号办理任务
     */
    void completeWxTask(String taskId, String instanceId, String userId,Map<String, Object> variables);

    /**
     *
     * @author lyric
     * @date 2022/10/27 12:56
     * @param taskId
     * @param userId
     * 拾取任务
     */
    void claimTask(String taskId, String userId);

    /**
     *
     * @author lyric
     * @date 2022/10/27 13:39
     * 归还任务
     */
    void restoreTask(String taskId);


    /**
     *
     * @author lyric
     * @date 2022/10/30 11:47
     * @param key
     * @param userId
     * @return Integer
     *
     * 查询已办总数
     */
    int getDoneTotal(String key, String userId);

    /**
     *
     * @author lyric
     * @date 2022/10/30 12:30
     * @param key
     * @param userId
     * @return int
     *
     * 查询待办总数
     */
    int getTodoTotal(String key, String userId);
}
