/**
 * @description 封装公共校验规则
 * */

// 校验身份证
export function checkIdcard(rule, idCard, callback) {
  if (idCard && idCard.length == 18) {
    var idCard_string = JSON.stringify(idCard);
    var spstr = idCard_string.split("");
    var x = spstr[spstr.length - 2];
    if (x === "x") {
      return callback(new Error("身份证号最后一位X为大写"));
    }
    var reg = new RegExp(/^(\d{6})(\d{4})(\d{2})(\d{2})(\d{3})([0-9]|X)$/);
    var arrSplit = idCard.match(reg); //检查生日日期是否正确，value就是身份证号
    if (!arrSplit) {
      return callback(new Error("身份证号格式有问题，请重新输入"));
    }
    var dtmBirth = new Date(arrSplit[2] + "/" + arrSplit[3] + "/" + arrSplit[4]);
    var bGoodDay;
    bGoodDay = dtmBirth.getFullYear() == Number(arrSplit[2]) && dtmBirth.getMonth() + 1 == Number(arrSplit[3]) &&
      dtmBirth.getDate() == Number(arrSplit[4]);
    if (!bGoodDay) {
      return callback(new Error("输入的身份证号里出生日期不对！"));
    } else {
      //检验18位身份证的校验码是否正确。 //校验位按照ISO 7064:1983.MOD 11-2的规定生成，X可以认为是数字10。
      var valnum;
      var arrInt = new Array(7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2);
      var arrCh = new Array('1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2');
      var nTemp = 0,
        i;
      for (i = 0; i < 17; i++) {
        nTemp += idCard.substr(i, 1) * arrInt[i];
      }
      valnum = arrCh[nTemp % 11];
      if (valnum != idCard.substr(17, 1)) {
        return callback(new Error("末位校验码应该为：" + valnum));
      }
      return callback();
    }

  } else {
    return callback(new Error("输入的身份证号不满足18位！"));
  }
}


