/**
 * @param {string} email
 * @returns {Boolean}
 */
export function validEmail(email) {
  const reg = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/
  return reg.test(email)
}

/**
 * @param {string} url
 * @returns {Boolean}
 */
export function validURL(url) {
  const reg = /^(https?|ftp):\/\/([a-zA-Z0-9.-]+(:[a-zA-Z0-9.&%$-]+)*@)*((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]?)(\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])){3}|([a-zA-Z0-9-]+\.)*[a-zA-Z0-9-]+\.(com|edu|gov|int|mil|net|org|biz|arpa|info|name|pro|aero|coop|museum|[a-zA-Z]{2}))(:[0-9]+)*(\/($|[a-zA-Z0-9.,?'\\+&%$#=~_-]+))*$/
  return reg.test(url)
}

/**
 * @param {string} value
 * @returns {Boolean}
 */
export function isValidNum(value) {
  return /^[0-9]+$/.test(value)
}

/**
 * @param {string} sex
 * @returns {Boolean}
 */
export function isValidSex(sex) {
  return /^[男女]+$/.test(value)
}

/**
 * @param {string} value
 * @returns {Boolean}
 */
export function isValidIdCardNum(value) {
  return /^[0-9]+$/.test(value)
}

/**
 * 常用element表单校验函数通式
 * @param {Function} fn - 可以返回布尔值的一元匹配函数
 * @param {String} invalidMsg - 不匹配时要返回的信息字符串
 * @param {Boolean} allowEmpty - 允不允许空值
 */
export function ordinaryValidator(fn, invalidMsg, allowEmpty = false) {
  return function (rule, value, callback) {
    const isEmpty = value => (value === '' || value === undefined || value === null)
    // 在不允许为空的时候为空
    if (isEmpty(value) && !allowEmpty) {
      callback(new Error('请填写相关字段'));
    } else {
      // 在不为空的情况下不匹配
      if (!fn(value) && !isEmpty(value)) {
        callback(new Error(invalidMsg))
      } else {
        callback()
      }
    }
  }
}
