/**
 * @description 获取一定范围内的年份
 * @param range 范围
 * */

export function getYearList(range = 30) {
  const year = new Date().getFullYear();
  if (range > year) return [];
  const list = [];
  for (let i = 0; i < 30; ++i) {
    list.push({ value: year - i, label: (year - i).toString() + '年' })
  }
  return list;
}
