import Layout from "@/layout";

export default [
  //通知公告--查看更多
  {
    path: "/indexMould/notification",
    component: Layout,
    hidden: true,
    permissions: ["system:user:edit"],
    children: [
      {
        path: "message",
        component: () =>
          import("@/views/smartSchool/indexMould/notification/message"),
        name: "message",
        meta: { title: "通知" },
      },
    ],
  },
  {
    path: "/indexMould/myDuty",
    component: Layout,
    hidden: true,
    permissions: ["system:user:edit"],
    children: [
      {
        path: "/",
        component: () => import("@/views/smartSchool/indexMould/myDuty"),
        name: "myDuty",
        meta: { title: "值班表" },
      },
    ],
  },

  //我的任务--公文流转
  {
    path: "/indexMould/myTask",
    component: Layout,
    hidden: true,
    permissions: ["system:user:edit"],
    children: [
      {
        path: "documentFlow",
        component: () =>
          import("@/views/smartSchool/indexMould/myTask/documentFlow"),
        name: "documentFlow",
        meta: { title: "公文流转" },
      },
    ],
  },

  //我的任务--教职工请假审批
  {
    path: "/indexMould/teachManage",
    component: Layout,
    hidden: true,
    permissions: ["system:user:edit"],
    children: [
      {
        path: "teachLeaveApprove",
        component: () =>
          import("@/views/smartSchool/indexMould/myTask/teachLeaveApprove"),
        name: "teachLeaveApprove",
        meta: { title: "教职工请假审批" },
      },
    ],
  },
  //我的任务--礼堂申请审批
  {
    path: "/indexMould/myTask",
    component: Layout,
    hidden: true,
    permissions: ["system:user:edit"],
    children: [
      {
        path: "audApplicationapproval",
        component: () =>
          import(
            "@/views/smartSchool/indexMould/myTask/audApplicationapproval"
          ),
        name: "audApplicationapproval",
        meta: { title: "礼堂申请审批" },
      },
    ],
  },
  //我的任务--科室申请审批
  {
    path: "/indexMould/myTask",
    component: Layout,
    hidden: true,
    permissions: ["system:user:edit"],
    children: [
      {
        path: "depBudgetapproval",
        component: () =>
          import("@/views/smartSchool/indexMould/myTask/depBudgetapproval"),
        name: "depBudgetapproval",
        meta: { title: "科室预算审批" },
      },
    ],
  },

  //我的任务--公文流转--评阅人操作，发起人操作，传阅人操作
  {
    path: "/index/myTask",
    component: Layout,
    hidden: true,
    permissions: [
      "childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index",
    ],
    children: [
      {
        path: "initiator",
        component: () =>
          import(
            "@/views/smartSchool/indexMould/myTask/documentFlow/initiator.vue"
          ),
        name: "initiator",
        meta: {
          title: "发起人操作",
        },
      },
      {
        path: "circulator",
        component: () =>
          import(
            "@/views/smartSchool/indexMould/myTask/documentFlow/circulator.vue"
          ),
        name: "circulator",
        meta: {
          title: "批阅人操作",
        },
      },
      {
        path: "reviewer",
        component: () =>
          import(
            "@/views/smartSchool/indexMould/myTask/documentFlow/reviewer.vue"
          ),
        name: "reviewer",
        meta: {
          title: "传阅人操作",
        },
      },
    ],
  },
  //我的任务--采购申请审批
  {
    path: "/indexMould/myTask",
    component: Layout,
    hidden: true,
    permissions: ["system:user:edit"],
    children: [
      {
        path: "purchaseApproval",
        component: () =>
          import("@/views/smartSchool/indexMould/myTask/purchaseApproval"),
        name: "purchaseApproval",
        meta: { title: "采购申请审批" },
      },
    ],
  },
  //我的任务--学生请假审批
  {
    path: "/indexMould/myTask",
    component: Layout,
    hidden: true,
    permissions: ["system:user:edit"],
    children: [
      {
        path: "studentLeaveApproval",
        component: () =>
          import("@/views/smartSchool/indexMould/myTask/studentLeaveApproval"),
        name: "studentLeaveApproval",
        meta: { title: "学生请假审批" },
      },
    ],
  },
  //我的任务--公文流转--历史人物--查看
  {
    path: "/indexMould/myTask",
    component: Layout,
    hidden: true,
    permissions: ["system:user:edit"],
    children: [
      {
        path: "documentFlow/reviewer",
        component: () =>
          import(
            "@/views/smartSchool/indexMould/myTask/documentFlow/reviewer.vue"
          ),
        name: "Reviewer",
        meta: { title: "公文流转历史任务" },
      },
    ],
  },
];
