/**
 * @description 公共常量
 * */

// 文本域字数（默认200）

const TEXT_SIZE_TEL = 11;
const TEXT_SIZE_TWENTY = 20;
const TEXT_SIZE_FIFTY = 50;
const TEXT_SIZE_ONE_HU = 100;
const TEXT_SIZE = 200;
const TEXT_SIZE_FIVE_HU = 500;
const TEXT_SIZE_ONE_TH = 1000;
const TEXT_SIZE_TWO_TH = 2000;


// 导出类别

const ExportType = {
  'TOTAL': 1,
  'SELECT': 2,
  'QUERY': 3
};

// 导出类别集合
const ExportTypes = [
  {label: '导出全部', type: ExportType.TOTAL},
  {label: '导出选中', type: ExportType.SELECT},
  {label: '根据查询条件导出', type: ExportType.QUERY}
];


// 民族
const Nations = [
  {label: "汉族"},
  {label: "壮族"},
  {label: "回族"},
  {label: "满族"},
  {label: "维吾尔族"},
  {label: "苗族"},
  {label: "彝族"},
  {label: "土家族"},
  {label: "藏族"},
  {label: "蒙古族"},
  {label: "侗族"},
  {label: "布依族"},
  {label: "瑶族"},
  {label: "白族"},
  {label: "朝鲜族"},
  {label: "哈尼族"},
  {label: "黎族"},
  {label: "哈萨克族"},
  {label: "傣族"},
  {label: "畲族"},
  {label: "傈僳族"},
  {label: "东乡族"},
  {label: "仡佬族"},
  {label: "拉祜族"},
  {label: "佤族"},
  {label: "水族"},
  {label: "纳西族"},
  {label: "羌族"},
  {label: "土族"},
  {label: "仫佬族"},
  {label: "锡伯族"},
  {label: "柯尔克孜族"},
  {label: "景颇族"},
  {label: "达斡尔族"},
  {label: "撒拉族"},
  {label: "布朗族"},
  {label: "毛南族"},
  {label: "塔吉克族"},
  {label: "普米族"},
  {label: "阿昌族"},
  {label: "怒族"},
  {label: "鄂温克族"},
  {label: "京族"},
  {label: "基诺族"},
  {label: "德昂族"},
  {label: "保安族"},
  {label: "俄罗斯族"},
  {label: "裕固族"},
  {label: "乌孜别克族"},
  {label: "门巴族"},
  {label: "鄂伦春族"},
  {label: "独龙族"},
  {label: "赫哲族"},
  {label: "高山族"},
  {label: "珞巴族"},
  {label: "塔塔尔族"}
];


const Area = {
  11: "北京", 12: "天津", 13: "河北", 14: "山西", 15: "内蒙古", 21: "辽宁", 22: "吉林", 23: "黑龙江",
  31: "上海", 32: "江苏", 33: "浙江", 34: "安徽", 35: "福建", 36: "江西", 37: "山东", 41: "河南", 42: "湖北",
  43: "湖南", 44: "广东", 45: "广西", 46: "海南", 50: "重庆", 51: "四川", 52: "贵州", 53: "云南", 54: "西藏",
  61: "陕西", 62: "甘肃", 63: "青海", 64: "宁夏", 65: "新疆", 71: "台湾", 81: "香港", 82: "澳门", 91: "国外"
};


// 性别
const Gender = {
  'MALE': '0',
  'FEMALE': '1',
};

/** 临时常量 */
const TempGrades = [
  {value: '1', label: '高一'},
  {value: '2', label: '高二'},
  {value: '3', label: '高三'},
];


const TempSchoolInfo = {
  introduce: `<a>东营市第二中学</a>于<a href="javascript:;">2000年9月成立</a>，
              2016年8月25日学校迁入新址（东营区海河路589号）办学。
              校园以“生态学府、水绿书院”为设计理念，占地面积356亩，
              总建筑面积17.8万平方米,概算投资8.6亿元，是一所集数字化、信息化、智能化于一体的现代化学校，
              山东省东营市唯一的“二星级”绿色高中校园。学校先后荣获全国青少年校园足球特色学校、教育部国防教育特色学校、
              全国节约型公共机构示范单位、全国生态文明教育示范学校、全国校园文学活动先进单位、
              全国百佳校园电视台、山东省文明校园、山东省教师专业发展研究基地、山东省学生发展指导示范基地、
              山东省家庭教育示范基地、山东省校园足球训练营、山东省青少年毒品预防教育“6.27”工程示范学校、
              山东省依法治校先进学校、山东省卫生先进单位、山东省地震科普示范学校、东营市文明单位、东营市文明校园、
              东营市规范化学校、东营市教学示范学校、东营市教育现代化学校、全市教育系统先进集体、东营市五一劳动奖状、
              东营市教育科研先进单位、东营市首批基础教育教研基地、东营市首批传统文化体验教育实验学校、东营市心理健康教育特色学校、
              东营市艺术教育实验学校、东营市家校共育示范学校、东营市平安校园示范单位、东营市语言文字规范化示范校、
              东营市抗击新冠肺炎疫情先进集体、东营市先进基层党组织等90余项荣誉和称号。`,
  kindergartenName: '东营市第二中学',
  timeOfEstablishment: '2000年9月',
  schoolMotto: '实以思进、搏以拓新',
  // legalRepresentative: '',
  address: '山东东营',
  synopsis: '学校以“实以思进、搏以拓新”为核心理念，从校情教情学情实际出发，确立了“能行教育、多元发展”办学思想，制定了“规范、改革、发展”的“三步走”十年工作规划，坚持办“适合”的教育，落实“立德树人”根本任务。2013-2015年为学校“规范建设”三年工程，以“管理”为引领，重打基础、建立规范，为学校精细化管理、高质量发展奠基，高考本科上线人数分别为77人、196人、386人。2016-2018年为学校“综合改革”三年工程，以“教学”为引领，探索建立了“双导”课堂教学模式，推行“小组合作”学习，实现了教育教学质量大提升，2016年，800名毕业生，高考本科上线566人；2017年，850名毕业生，高考本科上线人数653人；2018年，900名毕业生，高考本科上线人数793人。2019-2021年为学校“特色发展”三年工程，以“育人”为引领，突出“校本课程建设”、学科教研组建设、课程基地建设，深入推进“讲规则、有秩序”之系列校园建设工程，实施“生态教育”，打造“特色二中”，2019年，1080名毕业生，高考本科上线人数913人；2020年，1409名毕业生参加考试，高考本科上线人数再攀高峰，达到1200人，奠定了“两向三满意一建成”的“二次创业”基础目标；2021年，1519名毕业生参加考试，高考本科上线人数1320人，本科上线率位列全市高中第3名，创造了二中质量的新高度，很好地完成了“两向三满意一建成”的“二次创业”发展目标任务，为步入“优质、特色、生态”内涵质量发展奠定了坚实基础和高度自信。',
  teacherResources: '学校现有90个教学班，4500名在校生，400名教职工，其中专任教师360人，学历达标率100%。1人获得全国优秀教师称号，1人获得“齐鲁名师”称号，10人获得省级教学能手、优秀教师称号，57人获得市级教学能手、学科带头人、优秀教师称号，市级名师工作室3个。学校拥有先进的校园文化数字化、网络连接无缝化、校园办公自动化、教育资源信息化的“数字二中”办学环境和条件，学校配备机器人实验室、三D打印室、校园电视台、数学专用教室、历史实验室、地理探究实验室、心理实验室等最先进的教学设备和高科技实验设施，为同学们科学创新构建最前沿的阵地；拥有七月文学社、创新科技社、尚真书法社、焦点影像社、倚天司法社等57个学生社团，为同学们个性发展、特色成才、自主招生提供最广阔的舞台。',
};


export {
  TEXT_SIZE_TEL,
  TEXT_SIZE,
  TEXT_SIZE_TWENTY,
  TEXT_SIZE_FIFTY,
  TEXT_SIZE_ONE_HU,
  TEXT_SIZE_FIVE_HU,
  TEXT_SIZE_ONE_TH,
  TEXT_SIZE_TWO_TH,
  ExportType,
  ExportTypes,
  Nations,
  TempGrades,
  TempSchoolInfo,
  Gender,
  Area
}
