import request from '@/utils/request'

// 查询学校老师列表
export function listInform(query) {
  return request({
    url: '/school/teacher/teacherList',
    method: 'get',
    params: query
  })
}

// 查询学校老师详细
export function getInform(id) {
  return request({
    url: '/school/teacher/queryOne/' + id,
    method: 'get'
  })
}

// 新增学校老师
export function addInform(data) {
  return request({
    url: '/school/teacher/add',
    method: 'post',
    data: data
  })
}

// 修改学校老师
export function updateInform(data) {
  return request({
    url: '/school/teacher/edit',
    method: 'put',
    data: data
  })
}

// 删除学校老师
export function delInform(ids) {
  return request({
    url: '/school/teacher/remove/' + ids,
    method: 'delete'
  })
}

// 智能排课
export function createSchedule(data) {
  return request({
    url: '/schoolTimeTable/makeSchedule',
    method: 'post',
    data: data
  })
}

// 确认排课
export function saveSchedule(data) {
  return request({
    url: '/schoolTimeTable/saveSchedule',
    method: 'post',
    data: data
  })
}

// 分配角色
export function submitRoles(query) {
  return request({
    url: `/system/user/authRole`,
    method: 'put',
    query: query
  })
}

// 发送重置密码
export function sendResetPassword(query) {
  return request({
    url: '/system/user/resetPwd',
    method: 'Put',
    data: query
  })
}

//switch改变专用接口
export function statusChange(status, id) {
  return request({
    url: `/school/teacher/changeState/` + id,
    method: 'put',
    params: {status}
  })
}


