import request from '@/utils/request'

// 查询教师值班列表
export function listTeacherDuty(query) {
  return request({
    url: '/school/teacherDuty/list',
    method: 'get',
    params: query
  })
}

// 查询教师值班详细
export function getTeacherDuty(id) {
  return request({
    url: '/school/teacherDuty/queryOne/' + id,
    method: 'get'
  })
}

// 新增教师值班
export function addTeacherDuty(data) {
  return request({
    url: '/school/teacherDuty/add',
    method: 'post',
    data: data
  })
}

// 修改教师值班
export function updateTeacherDuty(data) {
  return request({
    url: '/school/teacherDuty/edit',
    method: 'put',
    data: data
  })
}

// 删除教师值班
export function delTeacherDuty(id) {
  return request({
    url: '/school/teacherDuty/delete/' + id,
    method: 'delete'
  })
}
