import request from '@/utils/request'

// 查询老师获奖情况列表
export function listTeacherAward(query) {
  return request({
    url: '/school/teacherAward/list',
    method: 'get',
    params: query
  })
}

// 查询老师获奖情况详细
export function getTeacherAward(id) {
  return request({
    url: '/school/teacherAward/queryOne/' + id,
    method: 'get'
  })
}

// 新增老师获奖情况
export function addTeacherAward(data) {
  return request({
    url: '/school/teacherAward/addOne',
    method: 'post',
    data: data
  })
}

// 修改老师获奖情况
export function updateTeacherAward(data) {
  return request({
    url: '/school/teacherAward/edit',
    method: 'put',
    data: data
  })
}

// 删除老师获奖情况
export function delTeacherAward(ids) {
  return request({
    url: '/school/teacherAward/remove/' + ids,
    method: 'delete'
  })
}

// 上传老师获奖图片
export function uploadAwardImg(data) {
  return request({
    url: '/common/upload',
    method: 'post',
    data: data
  })
}
