import request from "@/utils/request";

export function getList(queryParams, examId) {
  return request({
    url: `/examParticipation/getExamPeopleNum/${examId}`,
    method: 'get',
    params: queryParams
  })
}

//详情页面信息接口
export {
  getList as detailedInfo,
  BackToFrontTransfer as DetailFrontTransfer
} from "../ActivityResult/request.js"

export function computeResult(examId) {
  return request({
    url: `/examParticipation/getResult`,
    method: 'get',
    params:{examId}
  })
}

export class BackToFrontTransfer {
  constructor(data) {
    class Single {
      constructor(data) {
        this.id = data.id
        ///关键部分///
        this.activityTitle = data.examName
        this.optionScope = data.optionScope
        this.startTime = data.startTime
        this.state = data.state
        this.endTime = data.endTime
        this.isLeaderExam = data.isLeaderExam
        this.remark = data.remark
        this.deptName = data.deptName
        this.userId = data.userId
        this.pepCount = data.num
      }
    }

    return data.rows.map(item => new Single(item))
  }
}

export class statsFrontTransfer {
  constructor(data) {
    class Single {
      constructor(data) {
        this.id = data.id
        ///关键部分///
        this.sort = data.sort
        this.quizTitle = data.subjectTitle
        this.examId = data.examId
        return {...data, ...this}
      }
    }

    class OptionsStatsObj {
      constructor(data) {
        const AllOptions = [..."ABCDEFGH"],
          finalOptions = []
        AllOptions.forEach(el => {
          finalOptions.push({
            mark: el,
            isAvailable: Boolean(data[`option${el}`]),
            option: data[`option${el}`],
            score: data[`score${el}`],
            num: data[`num${el}`],
          })
        })
        return finalOptions
      }
    }

    return {
      data: data.rows.map(item => new Single(item)),
      option: data.rows.map(item => new OptionsStatsObj(item))
    }
  }
}
