import request from '@/utils/request'


//获取最新数据的年份
export function getNewYear() {
  return request({
    url: '/schoolGrade/getNewYear',
    method: 'get',
  })
}


// 查询学生列表
export function getCourseInfo(queryParams) {
  return request({
    url: '/schoolTimeTable/getSchoolSchedule',
    method: 'get',
    params: queryParams
  })
}


// 获取班级下拉树
export function getClassTree(queryParams) {
  return request({
    url: '/schoolClass/getClassTreeList',
    method: 'get',
    params: queryParams
  })
}


// 获取课程种类
export function getClassType() {
  return request({
    url: '/curriculum/list',
    method: 'get',
  })
}

//提交课表信息
export function saveClassTable(classId,termId,data) {
  return request({
    url: `/schoolTimeTable/addSchoolSchedule/${classId}/${termId}`,
    method: 'post',
    data: data
  })
}




