import request from "@/utils/request";

// 查询班级列表
export function getClassList(queryParams) {
  return request({
    url: '/schoolClass/list',
    method: 'get',
    params: queryParams
  })
}

// 新增班级
export function addClass(data) {
  return request({
    url: '/schoolClass/add',
    method: 'post',
    data: data,
  })
}

// 查询班级详情
export function getDetailInfo(id) {
  return request({
    url: '/schoolClass/queryOne/' + id,
    method: 'get'
  })
}

// 修改班级
export function editClass(postForm) {
  return request({
    url: '/schoolClass/edit',
    method: 'put',
    data: postForm
  })
}

// 删除班级
export function deleteClass(ids) {
  return request({
    url: '/schoolClass/remove/' + ids,
    method: 'delete'
  })
}

// 上传班徽
export function uploadAvater(avatarfile) {
  return request({
    url: '/schoolClass/updateAvatar',
    method: 'post',
    data: avatarfile,
  })
}

// 批量更新班级是否为毕业状态
export function allBY(ids) {
  return request({
    url: '/schoolClass/update/' + ids,
    method: 'put'
  })
}

// 批量操作
export function editBatch(postForm) {
  return request({
    url: '/schoolClass/batchAdd',
    method: 'post',
    data: postForm
  })
}

/** 获取班级下拉列表 */
export function getClassTreeList(queryForm) {
  return request({
    url: '/schoolClass/getClassTreeList',
    method: 'get',
    params: queryForm
  })
}

/** 获取学生列表 */
export function getStudentList(queryForm) {
  return request({
    url: '/schoolClass/getStudentList/' + queryForm.gradeId,
    method: 'get',
    params: queryForm
  })
}

/** 获取老师列表 */
export function getTeacherList(queryForm) {
  return request({
    url: '/schoolClass/getTeacherList/' + queryForm.gradeId,
    method: 'get',
    params: queryForm
  })
}


// 导入班级
export function importDataSchedule(file) {
  return request({
    url: '/schoolTimeTable/importDataSchedule',
    method: 'post',
    data: file
  })
}

// 任课教师列表 /schoolClassMentor/list
export function teacherList(gradeId, query) {
  return request({
    url: '/schoolClassMentor/list/' + gradeId,
    method: 'get',
    params: query,
  })
}



//查看老师详情
export function getTeacherInfo(teacherId) {
  return request({
    url: '/schoolClassMentor/queryOne/' + teacherId,
    method: 'get'
  })
}



// 删除教师与班级关系
export function delTeacherInfo(ids) {
  return request({
    url: '/schoolClassMentor/remove/' + ids,
    method: 'delete'
  })
}

// 修改教师与班级关系
export function editTeacherInfo(data) {
  return request({
    url: '/schoolClassMentor/edit',
    method: 'put',
    data: data,
  })
}

// 新增保存老师与班级关系
export function addTeacher(id, data) {
  return request({
    url: '/schoolClassMentor/add/' + id,
    method: 'post',
    data: data
  })
}







