import request from '@/utils/request'

// 查询【请填写功能名称】列表
export function listDetail(query, infoId) {
  return request({
    url: '/schoolInfo/dataList/' + infoId,
    method: 'get',
    params: query
  })
}

// 新增【请填写功能名称】
export function addDetail(data, infoId) {
  return request({
    url: '/schoolInfo/detail/add/' + infoId,
    method: 'post',
    data: data
  })
}

// 查询【请填写功能名称】详细
export function getDetail(id) {
  return request({
    url: '/schoolInfo/detail/getInfo/' + id,
    method: 'get'
  })
}

// 修改【请填写功能名称】
export function updateDetail(data) {
  return request({
    url: '/schoolInfo/detail/edit',
    method: 'put',
    data: data
  })
}

// 删除【请填写功能名称】
export function delDetail(id) {
  return request({
    url: '/schoolInfo/detail/delete/' + id,
    method: 'delete'
  })
}


// 信息发布-数据查看-导入
export function detailImport(data, infoId) {
  return request({
    url: '/schoolInfo/importData/' + infoId,
    method: 'post',
    data: data
  })
}

// 信息发布-数据查看-导出
export function detailExport(data, infoId) {
  return request({
    url: '/schoolInfo/export/' + infoId,
    method: 'post',
    data: data
  })
}

//教务-信息采集--数据、数据查看-模板
export function detailTemplate() {
  return request({
    url: '/schoolInfo/importTemplate',
    method: 'post',
  })
}










