import request from '@/utils/request'

//教务-信息采集-查询列表
export function listAcquisition(query) {
  return request({
    url: '/schoolInfo/list',
    method: 'get',
    params: query
  })
}

//教务-信息采集-新增
export function addAcquisition(data) {
  return request({
    url: '/schoolInfo/add',
    method: 'post',
    data: data
  })
}

//教务-信息采集-详细
export function getAcquisition(id) {
  return request({
    url: '/schoolInfo/getInfo/' + id,
    method: 'get'
  })
}

//教务-信息采集-修改
export function updateAcquisition(data) {
  return request({
    url: '/schoolInfo/edit',
    method: 'put',
    data: data
  })
}

//教务-信息采集-删除
export function delAcquisition(id) {
  return request({
    url: '/schoolInfo/delete/' + id,
    method: 'delete'
  })
}


//教务-信息采集-发布
export function bublicAcquisition(id) {
  return request({
    url: '/schoolInfo/pub/' + id,
    method: 'put',
  })
}

//教务-信息采集-撤回
export function revokeAcquisition(id) {
  return request({
    url: '/schoolInfo/withdraw/' + id,
    method: 'put',
  })
}


//教务-信息采集-结束
export function endAcquisition(id) {
  return request({
    url: '/schoolInfo/end/' + id,
    method: 'put',
  })
}








