import request from '@/utils/request'

// 查询学生请假信息列表
export function listLeave(query) {
  return request({
    url: '/school/studentLeave/list',
    method: 'get',
    params: query
  })
}

// 查询学生请假信息详细
export function getLeave(id) {
  return request({
    url: '/school/studentLeave/queryOne/' + id,
    method: 'get'
  })
}

// 新增学生请假信息
export function addLeave(data) {
  return request({
    url: '/school/studentLeave/add',
    method: 'post',
    data: data
  })
}

// 修改学生请假信息
export function updateLeave(data) {
  return request({
    url: '/school/studentLeave/edit',
    method: 'put',
    data: data
  })
}

// 删除学生请假信息
export function delLeave(id) {
  return request({
    url: '/school/studentLeave/delete/' + id,
    method: 'delete'
  })
}

// 查询学生列表
export function listStudent(queryParams) {
  return request({
    url: '/school/student/list',
    method: 'get',
    params: queryParams
  })
}

/** 提交申请 */
export function submitApply(id) {
  return request({
    url: '/school/studentLeave/submitApply/' + id,
    method: 'post'
  })
}

/** 我的任务 */
export function taskList(queryForm) {
  return request({
    url: '/school/studentLeave/taskList',
    method: 'get',
    params: queryForm
  })
}

/** 历史任务 */
export function historyList(queryForm) {
  return request({
    url: '/school/studentLeave/taskDoneList',
    method: 'get',
    params: queryForm
  })
}

/** 销假列表（同历史任务接口，目前分两个接口来做） */
export function revokeList(queryForm) {
  return request({
    url: '/school/studentLeave/taskDoneList',
    method: 'get',
    params: queryForm
  })
}

/** 审批任务 */
export function complete({ taskId, instanceId, comment, pass }) {
  return request({
    url: `/school/studentLeave/complete/${taskId}/${instanceId}`,
    method: 'post',
    data: {
      comment,
      pass
    }
  })
}

/** 销假 */
export function cancelLeave(taskId, postForm) {
  return request({
    url: '/school/studentLeave/cancelLeave/' + taskId,
    method: 'post',
    data: postForm
  })
}
