import request from '@/utils/request'
// 查询学生德育明细列表
export function listEducationRuleDetails(queryParams) {
    return request({
      // url: `/school/educationRuleDetails/list/${ ruleId }`,
      // url: `/school/educationDetails/list/${ ruleId }`,
      url: `/school/educationRuleDetails/list`,
      method: 'get',
      params: queryParams
    })
  }
  // 查询学生德育规则明细
export function getEducation(id) {
    return request({
      url: '/school/educationRuleDetails/queryOne/' + id,
      method: 'get'
    })
  }
  
  // 新增学生德育规则明细
  export function addEducation(data) {
    return request({
      url: '/school/educationRuleDetails/add/' + data.ruleId,
      method: 'post',
      data: data
    })
  }
  
  // 修改学生德育规则明细
  export function updateEducation(data) {
    return request({
      url: '/school/educationRuleDetails/edit',
      method: 'put',
      data: data
    })
  }
  
  // 删除学生德育规则明细
  export function delEducation(ids) {
    return request({
      url: '/school/educationRuleDetails/delete/' + ids,
      method: 'delete'
    })
  }