import request from "@/utils/request";
//查看设备报修列表
export function getRepair(query) {
  return request({
    url: "/equipmentRepair/list",
    method: "get",
    params: query,
  });
}
//新增设备报修
export function addRepair(data) {
  return request({
    url: "/equipmentRepair/add",
    method: "post",
    data,
  });
}
//修改设备报修
export function editRepair(data) {
  return request({
    url: "/equipmentRepair/edit",
    method: "put",
    data: data,
  });
}
//查看设备报修详细信息
export function queryRepair(id) {
  return request({
    url: "/equipmentRepair/" + id,
    method: "get",
  });
}

//删除设备报修
export function deleteRepair(id) {
  return request({
    url: "/equipmentRepair/delete/" + id,
    method: "post",
  });
}
//根据自编码获取设备信息
export function getRepairencode(encode) {
  return request({
    url: "/equipmentRepair/getEquipment/" + encode,
    method: "get",
  });
}

//获取修理人下拉框
export function getRepairname() {
  return request({
    url: "/equipmentRepair/getRepair",
    method: "get",
  });
}
