import request from '@/utils/request'

// 查询值班管理列表
export function listDuty(query) {
  return request({
    url: '/duty/list',
    method: 'get',
    params: query
  })
}

// 查询值班管理详细
export function getDuty(id) {
  return request({
    url: '/duty/queryById/' + id,
    method: 'get'
  })
}

// 新增值班管理
export function addDuty(data) {
  return request({
    url: '/duty/add',
    method: 'post',
    data: data
  })
}

// 修改值班管理
export function updateDuty(data) {
  return request({
    url: '/duty/edit',
    method: 'put',
    data: data
  })
}

// 删除值班管理
export function delDuty(id) {
  return request({
    url: '/duty/delete/' + id,
    method: 'delete'
  })
}

// 信息发布
export function infoPublish(id) {
  return request({
    url: `/duty/published/${id}`,
    method: 'put'
  })
}

// 信息撤回
export function infoWithdraw(id) {
  return request({
    url: `/duty/withdraw/${id}`,
    method: 'put'
  })
}

// 任务数量
export function getDutyDetail(id,dutyType) {
  if (dutyType === "0") {
    // console.log('我是节日')
    /******************** 是hoilday还是holiday？ ********************/
    return request({
      url: `/dutyDetails/queryHoilday/${id}`,
      method: 'get',
    })
  } else {
    // console.log('我是寒暑假')
    return request({
      url: `/dutyDetails/queryVacation/${id}`,
      method: 'get',
    })
  }

}
