import request from '@/utils/request'

export function getOfficialView(id) {
  return request({
    url: '/schoolofficialflow/review/getInfo/' + id,
    method: 'get'
  })
}

export function downloadFile(params) {
  return request({
    url: '/schoolOffical/downloadFile',
    responseType: 'blob', // 表明返回服务器返回的数据类型
    method: 'post',
    data: params
  })
    .then(result => {
      //创建一个Blob对象接收后端传来的文件流
      const blob = new Blob([result], {
        type: 'application/octet-stream'
      })
      const downloadElement = document.createElement('a')
      // 创建下载的链接
      const href = window.URL.createObjectURL(blob)
      downloadElement.href = href
      // 下载后文件名
      downloadElement.download = params.name
      document.body.appendChild(downloadElement)
      // 点击下载
      downloadElement.click()
      // 下载完成移除元素
      document.body.removeChild(downloadElement)
      // 释放掉blob对象
      window.URL.revokeObjectURL(href)
    })
    .catch(err => {
      this.$message.error(err.message)
    })
}
