import request from '@/utils/request'

export function listOfficial(query) {
  return request({
    url: '/schoolOffical/selectListVo',
    method: 'get',
    params: query
  })
}

// export function listOfficial(query) {
//   return request({
//     url: '/schoolOffical/selectList',
//     method: 'get',
//     params: query
//   })
// }

// 修改
// export function getOfficial(id) {
//   return request({
//     url: '/schoolOffical/getInfo/' + id,
//     method: 'get'
//   })
// }
export function getOfficial(id) {
  return request({
    url: '/schoolofficialflow/review/getInfo/' + id,
    method: 'get'
  })
}

//暂存
export function addOfficial(data) {
  return request({
    url: '/schoolOffical/temporary',
    method: 'put',
    data: data
  })
}

//发文
export function updateOfficial(data) {
  return request({
    url: '/schoolOffical/message',
    method: 'put',
    data: data
  })
}

//发文
export function publicDocument(id) {
  return request({
    url: `/schoolOffical/pub/${id}`,
    method: 'put',
  })
}

export function delOfficial(id) {
  return request({
    url: '/schoolOffical/delete/' + id,
    method: 'delete'
  })
}

//获取批阅人列表
export function getApprover(query) {
  return request({
    url: `/school/teacherLeave/getSchoolLeader`,
    method: 'get',
    params: query
  })
}

// 文件上传方法
export function commonUpload(file, callback = null) {
  return request({
    url: '/schoolOffical/importFile',
    method: 'post',
    data: file,
    onUploadProgress: progress => {
      callback && callback(progress)
    }
  })
}
