import request from "@/utils/request";

// 新增材料编写情况
export function addMaterial(data) {
  return request({
    url: "/material/add",
    method: "post",
    data: data,
  });
}
// 修改材料编写情况
export function updateMaterial(data) {
  return request({
    url: "/material",
    method: "put",
    data: data,
  });
}
// 查看材料编写情况列表
export function getMaterial(query) {
  return request({
    url: "/material/list",
    method: "get",
    params: query,
  });
}

// 查看材料编写详情
export function listMaterial(ids) {
  return request({
    url: "/material/" + ids,
    method: "get",
  });
}

// 删除材料编写情况
export function delMaterial(ids) {
  return request({
    url: "/material/" + ids,
    method: "delete",
  });
}
