import request from '@/utils/request'

//查询预算项目列表
export function getBudgetList(queryParams) {
  return request({
    url: 'budget/list',
    method: 'get',
    params: queryParams
  })
}

//获取预算项目详细信息
export function queryBudget(id) {
  return request({
    url: 'budget/queryById/' + id,
    method: 'get',
  })
}

//新增
export function addBudget() {
  return request({
    url: 'budget/add',
    method: 'post',
    data: data
  })
}

//修改预算项目
export function editBudget(data) {
  return request({
    url: 'budget/edit',
    method: 'put',
    data: data
  })
}

//删除
export function deleteBudget(id) {
  return request({
    url: 'budget/delete/' + id,
    method: 'delete'
  })
}

// //导出
// export function exportBudget() {
//   return request({
//     url: 'budget/exportDept',
//     method: 'post'
//   })
// }
