import request from '@/utils/request'

// 查询办公申购列表
export function listPurchase() {
  return request({
    url: '/purchase/taskList',
    method: 'get',
  })
}

// 查询办公申购详细
export function getPurchase(id) {
  return request({
    url: `/purchase/getInfo/${id}`,
    method: 'get'
  })
}

// 新增办公申购
export function addPurchase(data) {
  return request({
    url: '/purchase/add',
    method: 'post',
    data: data
  })
}

// 修改办公申购
export function updatePurchase(data) {
  return request({
    url: '/purchase/edit',
    method: 'put',
    data: data
  })
}

// 删除办公申购
export function delPurchase(id) {
  return request({
    url: `/purchase/delete/${id}`,
    method: 'delete'
  })
}

