import request from '@/utils/request'

// 查询学校每日食谱列表
export function listRecipes(query) {
  return request({
    url: '/schoolRecipes/list/',
    method: 'get',
    params: query
  })
}

// 查询学校每日食谱详细
export function getRecipes(id) {
  return request({
    url: '/schoolRecipes/queryOne/' +id,
    method: 'get'
  })
}

// 新增学校每日食谱
export function addRecipes(data) {
  return request({
    url: '/schoolRecipes/add/',
    method: 'post',
    data: data
  })
}

// 修改学校每日食谱
export function updateRecipes(data) {
  return request({
    url: '/schoolRecipes/edit/',
    method: 'put',
    data:data
  })
}

// 删除学校每日食谱
export function delRecipes(id) {
  return request({
    url: '/schoolRecipes/delete/'+id,
    method: 'delete'
  })
}


// 导入
export function handleImport(file) {
  return request({
    url: `/schoolRecipes/importData/`,
    method: 'post',
    data: file
  })
}
