import request from '@/utils/request'

// 查询物品登记列表
export function listAssets(query) {
  return request({
    url: '/schoolAssets/list',
    method: 'get',
    params: query
  })
}

// 查询物品登记详细
export function getAssets(id) {
  return request({
    url: '/schoolAssets/queryById/' + id,
    method: 'get'
  })
}

export function getAssetsEnter(id) {
  return request({
    url: '/schoolAssetsEnter/queryInfo/' + id,
    method: 'get'
  })
}

// 新增物品登记
export function addAssets(data) {
  return request({
    url: '/schoolAssets/add',
    method: 'post',
    data: data
  })
}

// 修改物品登记
export function updateAssets(data) {
  return request({
    url: '/schoolAssets/edit',
    method: 'post',
    data: data
  })
}

// 删除物品登记
export function delAssets(id) {
  return request({
    url: '/schoolAssetsOut/delete/' + id,
    method: 'delete'
  })
}

//入库
export function AddAssetsEnter(data) {
  return request({
    url: '/schoolAssetsEnter/add',
    method: 'post',
    data: data
  })
}

//获取入库人列表
export function listEnterBy() {
  return request({
    url: '/school/teacher/teacherList',
    methods: 'get'
  })
}

export function EditAssetsEnter(data) {
  return request({
    url: '/schoolAssetsEnter/edit',
    method: 'post',
    data: data
  })
}

export function ListAssetsEnter(assetsId, query) {
  return request({
    url: `/schoolAssetsEnter/list/${assetsId}`,
    method: 'get',
    params: query
  })
}

export function delAssetsEnter(ids) {
  return request({
    url: '/schoolAssetsEnter/delete/' + ids,
    method: 'delete'
  })
}

//出库
// 增加
export function AddAssetsOut(query) {
  return request({
    url: '/schoolAssetsOut/add',
    method: 'post',
    data: query
  })
}

//查询详细
export function outStorageQueryOne(id) {
  return request({
    url: `/schoolAssetsOut/queryInfo/${id}`,
    method: 'get',
  })
}

//修改
export function EditAssetsOut(query) {
  return request({
    url: '/schoolAssetsOut/edit',
    method: 'post',
    data: query
  })
}

// 列表查询
export function ListAssetsOut(assetsId, query) {
  return request({
    url: `/schoolAssetsOut/list/${assetsId}`,
    method: 'get',
    params: query
  })
}

// 删除
export function delAssetsOut(id) {
  return request({
    url: '/schoolAssetsOut/delete/' + id,
    method: 'delete'
  })
}

// 查询入库人
export function getTeacherList(data) {
  return request({
    url: '/school/teacher/teacherList',
    method: 'get' ,
    params: data
  })
}

