import request from '@/utils/request'

// 查询会议信息列表
export function listConference(query) {
  return request({
    url: '/schoolConference/list',
    method: 'get',
    params: query
  })
}

// 查询会议信息详细
export function getConference(id) {
  return request({
    url: '/schoolConference/getInfo/' + id,
    method: 'get'
  })
}

// 新增会议信息
export function addConference(data) {
  return request({
    url: '/schoolConference/add',
    method: 'post',
    data: data
  })
}

// 修改会议信息
export function updateConference(data) {
  return request({
    url: '/schoolConference/edit',
    method: 'put',
    data: data
  })
}

// 删除会议信息
export function delConference(ids) {
  return request({
    url: '/schoolConference/delete/' + ids,
    method: 'delete'
  })
}

//导出表格选中行数据
export function exportPart(ids) {
  return request({
    url: '/schoolConference/export/' + ids,
    method: 'post',
    data: ids
  })
}

//导出表格所有数据
export function exportFull() {
  return request({
    url: '/schoolConference/export',
    method: 'post',
  })
}
//上传
export function uploadFile(data) {
  return request({
    url: '/common/upload',
    method: 'post',
    data: data
  })
}

// 下载文件
export function downloadFile(query) {
  return request({
    responseType: 'blob',
    url: '/system/file/download?filename=' + query,
    method: 'get'
  })
}

// 查询场地列表
// export function listArea(query) {
//   return request({
//     url: '/areaDetail/list',
//     method: 'get',
//     params: query
//   })
// }
