import request from "@/utils/request";

// 任课教师列表 /schoolClassMentor/list
export function teacherList(gradeId, query) {
  return request({
    url: '/schoolClassMentor/list/' + gradeId,
    method: 'get',
    params: query,
  })
}

// 新增保存老师与班级关系
export function addTeacher(teacherId, data) {
  return request({
    url: '/schoolClassMentor/add/' + teacherId,
    method: 'post',
    data: data
  })
}

//查看老师详情
export function getTeacherInfo(teacherId) {
  return request({
    url: '/schoolClassMentor/queryOne/' + teacherId,
    method: 'get'
  })
}

// 修改教师与班级关系
export function editTeacherInfo(data) {
  return request({
    url: '/schoolClassMentor/edit',
    method: 'put',
    data: data,
  })
}

// 删除教师与班级关系
export function delTeacherInfo(ids) {
  return request({
    url: '/schoolClassMentor/remove/' + ids,
    method: 'delete'
  })
}
