import request from '@/utils/request'

// 查询校历列表
export function listSchoolCalendar(data) {
  return request({
    url: '/schoolCalendar/list',
    method: 'get',
    params: data
  })
}

// 查询校历详细
export function getSchoolCalendar(id) {
  return request({
    url: '/schoolCalendar/queryOne/' + id,
    method: 'get',
  })
}

// 新增校历
export function addSchoolCalendar(data) {
  return request({
    url: '/schoolCalendar/add',
    method: 'post',
    data: data
  })
}

// 修改校历
export function updateSchoolCalendar(data) {
  return request({
    url: '/schoolCalendar/edit',
    method: 'put',
    data: data
  })
}

// 删除校历
export function delSchoolCalendar(ids) {
  return request({
    url: '/schoolCalendar/remove/' + ids,
    method: 'delete'
  })
}


// 查询校历下拉菜单
export function getSchoolCalendarForSelecter() {
  return request({
    url: '/schoolCalendar/getSchoolCalendarForSelecter',
    method: 'get',
  })
}
