// 社团风采信息
import request from '@/utils/request';

// 查询社团风采信息列表
export function getCommunityInfo(data) {
  return request({
    url: '/fc/list',
    method: 'get',
    params: data
  })
}


// 获取社团风采详细信息列表
export function listCommunityInfo(id) {
  return request({
    url: '/fc/'+ id,
    method: 'get',
  })
}

// 修改社团信息
export function editCommunityInfo(data) {
  return request({
    url: '/fc',
      method: 'put',
       data: data
  })
}

//新增社团信息
export function addCommunityInfo(data) {
  return request({
    url: '/fc',
      method: 'post',
       data: data
  })
}



// 是否发布
export function isCommunityFb(data) {
  return request({
    url: '/fc/isfb',
    method: 'post',
    data: data
  })
}


// 删除社团风采信息
export function delCommunityInfo(id) {
  return request({
    url: '/fc/'+ id,
    method: 'delete'
  })
}