// 社团基础信息
import request from '@/utils/request';

// 查询社团信息列表
export function getCommunityInfo(data) {
  return request({
    url: '/info/list',
    method: 'get',
    params: data
  })
}


// 查询社团详细信息列表
export function listCommunityInfo(id) {
  return request({
    url: '/info/'+ id,
      method: 'get',
  
  })
}

// 修改社团信息
export function editCommunityInfo(data) {
  return request({
    url: '/info',
      method: 'put',
       data: data
  })
}


// 新增社团信息
export function addCommunityInfo(data) {
  return request({
    url: '/info',
    method: 'post',
    data: data
  })
}


// 删除社团信息
export function delCommunityInfo(id) {
  return request({
    url: '/info/'+ id,
    method: 'delete'
  })
}


// 获取全校教师(不分页)
export function getTeachers(data) {
  return request({
    url: '/school/teacher/getTeachers',
    method: 'get',
    params: data
  })
}