import request from "@/utils/request";

//新增仪器
export function addInst(data) {
  return request({
    url: "/schoolInstrument/add",
    method: "post",
    data,
  });
}
//修改仪器
export function editInst(data) {
  return request({
    url: "/schoolInstrument/edit",
    method: "put",
    data,
  });
}
//查看仪器列表
export function getListyq(query) {
  return request({
    url: "/schoolInstrument/list",
    method: "get",
    params: query,
  });
}

// 查询详情
export function getInstxq(id) {
  return request({
    url: "/schoolInstrument/" + id,
    method: "get",
  });
}

//删除仪器
export function deleteInst(ids) {
  return request({
    url: "/schoolInstrument/" + ids,
    method: "delete",
    data: ids,
  });
}

//查看出入库明细列表
export function getListrk(query) {
  return request({
    url: "/schoolInstrumentDetail/list",
    method: "get",
    params: query,
  });
}

//仪器库存修改
export function getInstrumentDetail(data) {
  return request({
    url: "/schoolInstrumentDetail/add",
    method: "post",
    data,
  });
}
