package yangtz.cs.liu.wechat.service.impl.process;

import com.core.utils.HolidayDateUtil;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.activiti.mapper.ProcessMapper;
import yangtz.cs.liu.campus.vo.purchase.SchoolPurchaseVo;
import yangtz.cs.liu.campus.vo.student.StudentLeaveVO;
import yangtz.cs.liu.campus.vo.teacher.TeacherLeaveVO;
import yangtz.cs.liu.wechat.service.process.IProService;
import yangtz.cs.liu.wechat.vo.process.WxProcessVo;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.ruoyi.common.utils.StringUtils.isNull;
import static yangtz.cs.liu.campus.constant.EmployeeType.TEACH;
import static yangtz.cs.liu.wechat.constant.ProcessTypeConstant.*;

@Service
public class ProServiceImpl implements IProService {

    @Autowired
    private ProcessMapper processMapper;

    @Override
    public List<WxProcessVo> getList(List<TeacherLeaveVO> teaLeaveList, List<SchoolPurchaseVo> purchaseList, List<StudentLeaveVO> studentLeaveList) {
        //返回结果
        List<WxProcessVo> list = new ArrayList<>();
        //修改教师请假数据
        if (isNotNull(teaLeaveList) || teaLeaveList.size() > 0) {
            for (TeacherLeaveVO teacher : teaLeaveList) {
                WxProcessVo w = new WxProcessVo();
                w.setProcessType(TEALEAVE);
                w.setId(teacher.getId());
                w.setInstanceId(teacher.getInstanceId());
                w.setTaskId(teacher.getTaskId());
                String title = "";
                if (teacher.getType().equals(PUBNUM)) {
                    title += PUB;
                } else if (teacher.getType().equals(THINGNUM)) {
                    title += THING;
                } else if (teacher.getType().equals(ILLNESSNUM)) {
                    title += ILLNESS;
                } else if (teacher.getType().equals(MARRYNUM)) {
                    title += MARRY;
                } else if (teacher.getType().equals(LOSENUM)) {
                    title += LOSE;
                } else if (teacher.getType().equals(MATERNITYNUM)) {
                    title += MATERNITY;
                } else if (teacher.getType().equals(OTHERNUM)) {
                    title += OTHER;
                }
                title += "-" + teacher.getApplyOrgname() + "-" + teacher.getTeacherName();
                w.setTitle(title);

                //请假原由，从xxx-xxx因。。。而请假
                String content = "";
                if (teacher.getApplyType().equals(TEACH)) {
                    //格式化时间
                    String start = HolidayDateUtil.format1.format(teacher.getStartTime());
                    String end = HolidayDateUtil.format1.format(teacher.getEndTime());
                    content += "从" + start + "第" + teacher.getStartSort() + "节课到" + end
                            + "第" + teacher.getEndSort() + "节课因" + teacher.getReasonForLeave() + "需要请假";
                } else {
                    //格式化时间
                    String start = HolidayDateUtil.format.format(teacher.getStartTime());
                    String end = HolidayDateUtil.format.format(teacher.getEndTime());
                    content += "从" + start + "到" + end + "因" + teacher.getReasonForLeave() + "需要请假";
                }
                w.setContent(content);
                w.setState(teacher.getState());
                list.add(w);
            }
        }
        if (isNotNull(purchaseList) || purchaseList.size() > 0) {
            for (SchoolPurchaseVo purchase : purchaseList) {
                WxProcessVo w = new WxProcessVo();
                w.setProcessType(PURCHASE);
                w.setId(purchase.getId());
                w.setInstanceId(purchase.getInstanceId());
                w.setTaskId(purchase.getTaskId());
                String title = purchase.getPurchaseName() + "-" + purchase.getDeptName() + "-" + purchase.getApplyUser();
                w.setTitle(title);
                String content = "预算项目为" + purchase.getBudgetName() + "，采购总价为" + purchase.getPurchaseMoney()
                        + "元，期望审批通过日期为" + HolidayDateUtil.format1.format(purchase.getExpectedDate());
                w.setContent(content);
                w.setState(purchase.getState());
                list.add(w);
            }
        }

        if (isNotNull(studentLeaveList) || studentLeaveList.size() > 0) {
            for (StudentLeaveVO studentLeaveVO : studentLeaveList) {
                WxProcessVo w = new WxProcessVo();
                w.setProcessType(STULEAVE);
                w.setId(studentLeaveVO.getId());
                w.setInstanceId(studentLeaveVO.getInstanceId());
                w.setTaskId(studentLeaveVO.getTaskId());
                w.setTaskName(studentLeaveVO.getTaskName());
                String title = "";
                if (studentLeaveVO.getType().equals(PUBNUM)) {
                    title += PUB;
                } else if (studentLeaveVO.getType().equals(THINGNUM)) {
                    title += THING;
                } else if (studentLeaveVO.getType().equals(ILLNESSNUM)) {
                    title += ILLNESS;
                } else if (studentLeaveVO.getType().equals(MARRYNUM)) {
                    title += MARRY;
                } else if (studentLeaveVO.getType().equals(LOSENUM)) {
                    title += LOSE;
                } else if (studentLeaveVO.getType().equals(MATERNITYNUM)) {
                    title += MATERNITY;
                } else if (studentLeaveVO.getType().equals(OTHERNUM)) {
                    title += OTHER;
                }
//                title += "-" + studentLeaveVO.getApplyUser();
                title += "-" + studentLeaveVO.getStudentName();
                w.setTitle(title);
                //请假原由，从xxx-xxx因。。。而请假
                String content = "";
                //格式化时间
                String start = HolidayDateUtil.format.format(studentLeaveVO.getStartTime());
                String end = HolidayDateUtil.format.format(studentLeaveVO.getEndTime());
                content += "从" + start + "到" + end + "因" + studentLeaveVO.getLeaveReason() + "需要请假";
                w.setContent(content);
                w.setState(studentLeaveVO.getState());
                list.add(w);
            }
        }

        if (StringUtils.isNull(list) || list.size() == 0) {
            return new ArrayList<>();
        }
        List<WxProcessVo> resList = list.stream().sorted(Comparator.comparing(WxProcessVo::getState).reversed()).collect(Collectors.toList());
        return resList;
    }

    @Override
    public Long getRunNum(String userId) {
        return processMapper.getRunNum(userId);
    }


}
