package yangtz.cs.liu.wechat.service.impl.attendance;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.ExceptionHandler;
import yangtz.cs.liu.campus.domain.student.SchoolEducation;
import yangtz.cs.liu.campus.mapper.student.SchoolEducationDetailsMapper;
import yangtz.cs.liu.campus.mapper.student.SchoolEducationMapper;
import yangtz.cs.liu.wechat.service.attendance.IStudentAttendanceService;
import yangtz.cs.liu.wechat.vo.attendance.EducationVO;
import yangtz.cs.liu.wechat.vo.attendance.SchoolEducationDetailsVO;
import yangtz.cs.liu.wechat.vo.attendance.SchoolEducationVO;

import java.util.ArrayList;
import java.util.List;

@Service
public class StudentAttendanceServiceImpl extends ServiceImpl<SchoolEducationMapper,SchoolEducation> implements IStudentAttendanceService {


    @Autowired
    private SchoolEducationDetailsMapper schoolEducationDetailsMapper;

    @Autowired
    private SchoolEducationMapper schoolEducationMapper;

    @Override
    public List<SchoolEducationVO> getAttendance(SchoolEducation schoolEducation) {
        return getEducateDetail(schoolEducation);
    }

    @Override
    public List<EducationVO> getAttendanceList(SchoolEducation schoolEducation) {
        List<SchoolEducation> schoolEducations = schoolEducationMapper.queryTime(schoolEducation);
        if(StringUtils.isNull(schoolEducations)){
            throw new BaseException("此同学还未有德育评测!");
        }
        List<EducationVO> educationVO = new ArrayList<>();
        for(SchoolEducation s:schoolEducations){
            s.setStudentId(schoolEducation.getStudentId());
            EducationVO e = new EducationVO();
            e.setPatrolDate(s.getPatrolDate());
            e.setSchoolEducationVOList(getEducateDetail(s));
            educationVO.add(e);
        }

        return educationVO;
    }

    public  List<SchoolEducationVO> getEducateDetail(SchoolEducation schoolEducation){
        List<SchoolEducationVO> schoolEducationVOList= new ArrayList<>();
        List<SchoolEducation> schoolEducations = schoolEducationMapper.queryList(schoolEducation);
        if(schoolEducations.size() == 0){
            return schoolEducationVOList;
        }
        for(SchoolEducation s:schoolEducations){
            SchoolEducationVO schoolEducationVO =new SchoolEducationVO();
            BeanUtils.copyProperties(s,schoolEducationVO);
            //更具id获取 德育检查详情数据
            List<SchoolEducationDetailsVO> dtailsById = schoolEducationDetailsMapper.getDdtailsById(s.getId());
            schoolEducationVO.setSchoolEducationDetailsVO(dtailsById);
            schoolEducationVOList.add(schoolEducationVO);
        }
        return schoolEducationVOList;
    }
}
