package yangtz.cs.liu.wechat.service.api;

import yangtz.cs.liu.campus.domain.temp.*;
import yangtz.cs.liu.wechat.domain.template.LeaveStateTemplate;
import yangtz.cs.liu.wechat.domain.template.LeaveTemplate;
import yangtz.cs.liu.wechat.domain.template.StudentLeaveTemplate;

public interface IWxApiService {

    /**
     * @param leaveTemplate
     * @return String
     * <p>
     * 请假回复消息模板
     * @author lyric
     * @date 2022/10/20 13:41
     */
    String sendTemplate(LeaveTemplate leaveTemplate);

    /**
     * @author lyric
     * @date 2022/11/16 14:50
     * 请假状态模板
     */
    String sendLeaveStateTemplate(LeaveStateTemplate leaveStateTemplate);

    //教职工请假模板
    String sendTeacherLeaveTemplate(TeacherLeaveTemplate template);

    //请假结果和销假通知
    String sendLeaveResultTemplate(LeaveResultTemplate template);

    //学生请假模板
    String sendStudentLeaveTemplate(StudentLeaveTemplate template);

    //采购申请模板
    String sendPurchaseTemplate(PurchaseTemplate template);

    //礼堂预约申请模板
    String sendAuditoriumTemplate(AuditoriumTemplate template);

    //科室预算申请模板
    String sendDepartmentBudgetTemplate(DepartmentBudgetTemplate template);

    //公文流转模板
    String sendOfficalTemplate(OfficalTemplate template);
}
