package yangtz.cs.liu.wechat.controller.teacher;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherSign;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherSignService;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;


/**
 * 公众号教职工考情记录
 */
@RestController
@RequestMapping("/wx/teacherSign")
public class WxSchoolTeacherSignController extends BaseController {

    @Autowired
    private ISchoolTeacherSignService schoolTeacherSignService;

    /**
     * 正常
     */
    public static final String NORMAL = "0";

    /**
     * 未打卡
     */
    public static final String UN_NORMAL = "1";

    /**
     * 教职工签到
     */
    @PostMapping("/sign/{teacherId}")
    public AjaxResult SignIn(@PathVariable("teacherId") Long teacherId, SchoolTeacherSign schoolTeacherSign) {

        /** TODO 暂时先这样 */
        schoolTeacherSign.setTeacherId(teacherId);
        schoolTeacherSign.setSignDate(new Date());
        schoolTeacherSign.setSignTime(new Date());
        schoolTeacherSign.setSignStatus(NORMAL);

        return toAjax(schoolTeacherSignService.save(schoolTeacherSign));
    }

    /**
     * 教职工查看自己的历史打卡记录
     */
    @GetMapping("/signList/{teacherId}")
    public AjaxResult signList(@PathVariable("teacherId") Long teacherId,SchoolTeacherSign schoolTeacherSign) {
        startPage();
        LambdaQueryWrapper<SchoolTeacherSign> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolTeacherSign::getTeacherId, teacherId)
                .apply(ObjectUtil.isNotNull(schoolTeacherSign.getParams().get("beginTime")),
                        "date_format(sign_date,'%Y-%m-%d') >= date_format('" + schoolTeacherSign.getParams().get("beginTime") + "','%Y-%m-%d') ")
                .apply(ObjectUtil.isNotNull(schoolTeacherSign.getParams().get("endTime")),
                        "date_format(sign_date,'%Y-%m-%d') <= date_format('" + schoolTeacherSign.getParams().get("endTime") + "','%Y-%m-%d') ")
        ;
        List<SchoolTeacherSign> list = schoolTeacherSignService.list(lqw);
        return AjaxResult.success(list);
    }


    /**
     * 获取具体某一天打卡细节
     *
     * @param signDate 具体日期  例如（2022-11-17）
     * @return
     */
    @GetMapping("/getDetail/{teacherId}")
    public AjaxResult getDetail(@PathVariable("teacherId") Long teacherId, @RequestParam("signDate") Date signDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String date = sdf.format(signDate);
        LambdaQueryWrapper<SchoolTeacherSign> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolTeacherSign::getTeacherId,teacherId).eq(SchoolTeacherSign::getSignDate, date);
        return AjaxResult.success(schoolTeacherSignService.getOne(lqw));
    }

}
