package yangtz.cs.liu.wechat.controller.teacher;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherResume;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherResumeService;

import java.util.List;

@RestController
@RequestMapping("/wx/teacherResume")
public class WxSchoolTeacherResumeController extends BaseController {

    @Autowired
    private ISchoolTeacherResumeService schoolTeacherResumeService;

    /**
     * 老师履历列表
     * @param schoolTeacherResume
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolTeacherResume schoolTeacherResume) {
        startPage();
        List<SchoolTeacherResume> list = schoolTeacherResumeService.queryList(schoolTeacherResume);
        return getDataTable(list);
    }
}
