package yangtz.cs.liu.wechat.controller.teacher;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherService;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherVO;

import java.util.List;


@RestController
@RequestMapping("/wx/teacher")
public class WxSchoolTeacherController extends BaseController {

    @Autowired
    private ISchoolTeacherService schoolTeacherService;

    @GetMapping("/list/{studentId}")
    public AjaxResult list(@PathVariable("studentId") Long studentId){
       return AjaxResult.success(schoolTeacherService.getTeacherInfo(studentId));
    }


    @GetMapping("/allTeacher")
    public TableDataInfo allTeacher(String teacherName){
        startPage();
        List<SchoolTeacher> schoolTeacherList = schoolTeacherService.queryList(teacherName);
        return getDataTable(schoolTeacherList);
    }


    /**
     * 查询学校老师列表
     */
    @GetMapping("/teacherList")
    public TableDataInfo list(SchoolTeacherVO schoolTeacher) {
        startPage();
        List<SchoolTeacher> list = schoolTeacherService.selectSchoolTeacherList(schoolTeacher);
        return getDataTable(list);
    }


}
