package yangtz.cs.liu.wechat.controller.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.student.SchoolStudentSection;
import yangtz.cs.liu.campus.service.student.ISchoolStudentSectionService;

import static com.ruoyi.common.utils.StringUtils.isNotNull;

@RestController
@RequestMapping("/wx/select")
public class WxSchoolStudentSectionController extends BaseController {

    @Autowired
    private ISchoolStudentSectionService schoolStudentSectionService;


    /**
     * 学生选课
     * @param schoolStudentSection
     * @return
     */
    @PostMapping("/chose")
    public AjaxResult chose(@RequestBody @Validated SchoolStudentSection schoolStudentSection){
        //查询学生是否有过选课
        LambdaQueryWrapper<SchoolStudentSection> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolStudentSection::getStudentId, schoolStudentSection.getStudentId());
        SchoolStudentSection studentSection = schoolStudentSectionService.getOne(lqw);
        if (isNotNull(studentSection)){
            throw new ServiceException("已经选过课,无法再次选择");
        }
        return AjaxResult.success(schoolStudentSectionService.save(schoolStudentSection));
    }

    /**
     * 学生选课内容
     * @param studentId
     * @return
     */
    @GetMapping("/studentChoice/{studentId}")
    public AjaxResult studentChoice(@PathVariable("studentId") Long studentId){
        LambdaQueryWrapper<SchoolStudentSection> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolStudentSection::getStudentId, studentId);
        SchoolStudentSection schoolStudentSection = schoolStudentSectionService.getOne(lqw);
        return AjaxResult.success(schoolStudentSection);
    }
}
