package yangtz.cs.liu.wechat.controller.schoolOffcial;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.file.PubFile;
import yangtz.cs.liu.campus.domain.schooloffical.SchoolOfficial;
import yangtz.cs.liu.campus.domain.schooloffical.SchoolOfficialFlow;
import yangtz.cs.liu.campus.service.schooloffical.ISchoolOfficalService;
import yangtz.cs.liu.campus.service.schooloffical.ISchoolOfficialFlowService;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherService;
import yangtz.cs.liu.campus.vo.schoolOfficial.SchoolOfficialFlowVo;
import yangtz.cs.liu.campus.vo.schoolOfficial.SchoolOfficialVo;
import yangtz.cs.liu.campus.vo.schooloffical.UserIdVo;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherVO;

import java.util.List;

import static yangtz.cs.liu.campus.constant.GradeConstant.SCHOOLLEADER;
import static yangtz.cs.liu.campus.constant.OfficalConstant.*;

@RestController
@RequestMapping("/wx/officialflow")
public class WxOfficialFlowController extends BaseController {

    @Autowired
    private ISchoolOfficalService schoolOfficalService;
    @Autowired
    private ISchoolOfficialFlowService flowService;
    @Autowired
    private ISchoolTeacherService schoolTeacherService;

    /**
     * 查询我的任务
     */
    @GetMapping("/taskList/{userId}")
    public AjaxResult myTaskList(@PathVariable Long userId, String state, SchoolOfficial schoolOffical) {
        List<SchoolOfficialVo> list = schoolOfficalService.myTaskList(userId, state, schoolOffical);
//        List<SchoolOfficialVo> schoolOfficialVoList = new ArrayList<>();
//        for (SchoolOfficialVo schoolOfficialVo : list) {
//            if (schoolOfficialVo.getReceiveType().equals("1") || schoolOfficialVo.getReceiveType().equals("2")){
//                schoolOfficialVoList.add(schoolOfficialVo);
//            }
//        }
        AjaxResult ajaxResult = AjaxResult.success(list);
        ajaxResult.put("total",list.size());
        return ajaxResult;
    }

    /**
     * 详情页
     * 分为两块，一块是公文详情，一块是该公文已被哪些人办理,
     */
    @GetMapping("/review/getInfo/{id}")
    public AjaxResult reviewGetInfo(@PathVariable Long id) {
        AjaxResult ajax = AjaxResult.success();
        SchoolOfficialVo offical = schoolOfficalService.getInfo(id);
        List<SchoolOfficialFlowVo> list = flowService.getReviewList(id);
        ajax.put("offical", offical);
        ajax.put("review", list);
        return ajax;

    }

    /**
     * 批阅人操作
     * 需传个批阅意见
     *
     * @return
     */
    @PutMapping("/review/{id}")
    public AjaxResult review(@PathVariable Long id, @RequestBody SchoolOfficialFlow schoolOfficialFlow) {
        if (StringUtils.isEmpty(schoolOfficialFlow.getOpinion())) {
            return AjaxResult.error("请输入批阅意见");
        }
        //设置查询条件
        SchoolOfficialFlow flow = new SchoolOfficialFlow();
        //主表id
        flow.setOfficialId(id);
        //当前批阅人id
        flow.setReceiveUser(schoolOfficialFlow.getReceiveUser());
        //批阅人类型
        flow.setReceiveType(REVIEWER);
        //状态（未完成）
        flow.setState(UNDONE);
        //意见
        flow.setOpinion(schoolOfficialFlow.getOpinion());
        return toAjax(flowService.review(flow));
    }

    /**
     * 发起人操作
     * id主键id
     * 批阅人单选传userId
     * 传阅接收人，多选传userIds
     * 二者只传一个
     *
     * @return
     */
    @PutMapping("/initiator/{id}")
    public AjaxResult initiator(@PathVariable Long id, @RequestBody UserIdVo vo) {
        if (StringUtils.isNotNull(vo.getUserId()) && StringUtils.isNotNull(vo.getUserIds())) {
            return AjaxResult.error("批阅人和传阅人两者只能传一个");
        }
        if (StringUtils.isNull(vo.getUserId()) && StringUtils.isNull(vo.getUserIds())) {
            return AjaxResult.error("批阅人和传阅人两者必须传一个");
        }
        if (StringUtils.isNotNull(vo.getUserId()) && vo.getUserIds().length != 0){
            return AjaxResult.error("批阅人和传阅人两者只能传一个");
        }
        if (StringUtils.isNull(vo.getUserId()) && vo.getUserIds().length == 0){
            return AjaxResult.error("批阅人和传阅人两者必须传一个");
        }
        return toAjax(flowService.chooseReview(id, vo.getUserId(), vo.getUserIds()));
    }

    /**
     * 传阅人操作
     * id主键id
     * 在传阅人第一次查看公文，点进去页面，或者关闭页面时发送请求，将当前传阅人状态改为已完成
     * 并判断该公文对应的所有传阅人状态是否都是已完成，若都已完成，则将该公文状态改为已完结
     *
     * @return
     */
    @PutMapping("/circulator/{id}")
    public AjaxResult circulator(@PathVariable Long id, @RequestBody UserIdVo vo) {
        //修改当前传阅人状态
        int num = flowService.editState(id, vo.getUserId(), CIRCULATOR);
        //判断所有传阅人状态是否，都已完成
        schoolOfficalService.judgeState(id);
        return toAjax(num);
    }

    /**
     * 获取校领导
     * */
    @GetMapping("/getSchoolLeader")
    public AjaxResult getSchoolLeader(SchoolTeacherVO teacher) {
        return AjaxResult.success(schoolTeacherService.getSectionLeader(null,SCHOOLLEADER,teacher));
    }

    /**
     * 查询教师list(全部或者按职工类型是带班的)
     */
    @GetMapping("/getTeacherList")
    public AjaxResult getTeacherList(SchoolTeacher teacher) {
        List<SchoolTeacher> list = schoolTeacherService.getAllTeachers(teacher);
        return AjaxResult.success(list);
    }

    /**
     * 修改附件
     */
    @PutMapping("/updateFile")
    public AjaxResult updateFile(@RequestBody PubFile pubFile){
        return toAjax(flowService.updateFile(pubFile));
    }
}
