package yangtz.cs.liu.wechat.controller.schoolInfo;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import io.swagger.models.auth.In;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolInfo.SchoolInfoAcquisition;
import yangtz.cs.liu.campus.domain.schoolInfo.SchoolInfoDetail;
import yangtz.cs.liu.campus.service.schoolInfo.ISchoolInfoAcquisitionService;
import yangtz.cs.liu.campus.service.schoolInfo.ISchoolInfoDetailService;

import java.util.List;
import java.util.stream.Collectors;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;
import static com.ruoyi.common.utils.StringUtils.isNull;

/**
 * 信息采集
 */
@RestController
@RequestMapping("/wx/schoolInfo")
public class WxSchoolInfoController extends BaseController {

    @Autowired
    private ISchoolInfoAcquisitionService schoolInfoAcquisitionService;

    @Autowired
    private ISchoolInfoDetailService schoolInfoDetailService;

    /**
     * 基础信息匹配，检查是否能去进行信息采集维护
     */
    @GetMapping("/match")
    public AjaxResult match(SchoolInfoDetail schoolInfoDetail) {
        LambdaQueryWrapper<SchoolInfoDetail> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotBlank(schoolInfoDetail.getIdCard()), SchoolInfoDetail::getIdCard, schoolInfoDetail.getIdCard())
                .eq(isNotBlank(schoolInfoDetail.getSchoolNo()), SchoolInfoDetail::getSchoolNo, schoolInfoDetail.getSchoolNo())
                .like(isNotBlank(schoolInfoDetail.getStudentName()), SchoolInfoDetail::getStudentName, schoolInfoDetail.getStudentName());
        List<SchoolInfoDetail> list = schoolInfoDetailService.list(lqw);
        if (isNull(list) || list.size() < 1) {
            throw new ServiceException("无匹配到的信息，无法维护");
        }
//        List<Long> collect = list.stream().map(SchoolInfoDetail::getInfoId).collect(Collectors.toList());
        return AjaxResult.success(list);
    }

    /**
     * 通过获取到的集合中的infoId，封装成集合传入，进行查询主表
     * @param ids infoId的集合
     */
    @GetMapping("/getAcquisitionList/{ids}")
    public TableDataInfo getAcquisitionList(@PathVariable("ids") List<Integer> ids) {
        startPage();
        List<SchoolInfoAcquisition> list = schoolInfoAcquisitionService.listByIds(ids);
        return getDataTable(list);
    }

    /**
     * 维护
     */
    @PutMapping("/maintain")
    public AjaxResult maintain(@RequestBody SchoolInfoDetail schoolInfoDetail) {
        return AjaxResult.success(schoolInfoDetailService.updateById(schoolInfoDetail));
    }

}
