package yangtz.cs.liu.wechat.controller.schoolExam;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.schoolexam.SchoolExam;
import yangtz.cs.liu.campus.domain.schoolexam.SchoolExamDetail;
import yangtz.cs.liu.campus.service.schoolexam.ISchoolExamDetailService;
import yangtz.cs.liu.campus.service.schoolexam.ISchoolExamService;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;


@RestController
@RequestMapping("/wx/schoolExam")
public class WxSchoolExamController extends BaseController {

    @Autowired
    private ISchoolExamService schoolExamService;

    @Autowired
    private ISchoolExamDetailService schoolExamDetailService;

    /*******************************老师*****************************/


    /**
     *
     * @author lyric
     * @date 2022/11/20 10:04
     * 查询所有
     */
    @GetMapping("/examList")
    public TableDataInfo examList(SchoolExam schoolExam) {
        startPage();
        List<SchoolExam> list = schoolExamService.queryList(schoolExam);
        return getDataTable(list);
    }

    /**
     * 老师查询自己所带的班级考试列表
     *
     * @param schoolExam
     * @return
     */
    @GetMapping("/list/{classId}")
    public TableDataInfo list(@PathVariable("classId") Long classId, SchoolExam schoolExam) {
        startPage();
        schoolExam.setClassId(classId);
        List<SchoolExam> schoolExamList = schoolExamService.queryList(schoolExam);
        return getDataTable(schoolExamList);
    }

    /**
     * 获取考试详细
     *
     * @param schoolExamDetail
     * @return
     */
    @GetMapping("/detail/{examId}")
    public TableDataInfo detail(@PathVariable("examId") Long examId, SchoolExamDetail schoolExamDetail) {
        schoolExamDetail.setExamId(examId);
        startPage();
        List<SchoolExamDetail> detailList = schoolExamDetailService.queryList(schoolExamDetail);
        return getDataTable(detailList);
    }


    /***************************家长****************************/

    /**
     * 家长获取孩子所有考试成绩
     *
     * @param studentId
     * @return
     */
    @GetMapping("/getChildExam")
    public TableDataInfo getChildExam(Long studentId, SchoolExam schoolExam) {
        startPage();
        List<SchoolExam> list = schoolExamService.getChildExam(studentId, schoolExam);
        return getDataTable(list);
    }


    /**
     * 家长获取孩子某次考试成绩
     *  TODO
     * @param examId
     * @param studentId
     * @return
     */
    @GetMapping("/getscore")
    public AjaxResult getStudentScore(Long examId, Long studentId) {
        LambdaQueryWrapper<SchoolExamDetail> lwq = new LambdaQueryWrapper<>();
        lwq
                .eq(isNotNull(examId), SchoolExamDetail::getExamId, examId)
                .eq(isNotNull(studentId), SchoolExamDetail::getStudentId, studentId)
        ;
        return AjaxResult.success(schoolExamDetailService.list(lwq));
    }

}
