package yangtz.cs.liu.wechat.controller.introduce;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.introduce.SchoolIntroduce;
import yangtz.cs.liu.campus.service.introduce.ISchoolIntroduceService;
import yangtz.cs.liu.wechat.vo.introduce.SchoolIntroduceVo;

import java.util.List;

/**
 * 园区介绍
 */
@RestController
@RequestMapping("/wx/introduce")
public class WxSchoolIntroduceController extends BaseController {


    @Autowired
    private ISchoolIntroduceService schoolIntroduceService;

    @GetMapping("/list")
    public TableDataInfo list(SchoolIntroduce schoolIntroduce) {
        startPage();
        List<SchoolIntroduce> list = schoolIntroduceService.queryList(schoolIntroduce);
        return getDataTable(list);
    }

    /**
     * 获取学校教学班数量，学生总数，教职工总数
     *
     * @return
     */
    @GetMapping("/getOther")
    public AjaxResult getOther(SchoolIntroduceVo schoolIntroduceVo) {
        SchoolIntroduceVo Vo_schoolIntroduce = schoolIntroduceService.getOther(schoolIntroduceVo);
        return AjaxResult.success(Vo_schoolIntroduce);
    }
}
