package yangtz.cs.liu.wechat.controller.experiment;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.framework.util.UserInfoUtil;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLab;
import yangtz.cs.liu.campus.service.impl.schoolLab.SchoolLabClassYearServiceImpl;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolLabService;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabClassYearVo;

/**
 * 实验室
 */
@RestController
@RequestMapping("/wx/schoolLab")
public class WxSchoolLabControoler extends BaseController {
  @Autowired
  private ISchoolLabService schoolLabService;

  @Autowired
  private UserInfoUtil userInfoUtil;

  @Autowired
  private SchoolLabClassYearServiceImpl schoolLabClassYearService;

  /**
   * 查询实验室列表
   */
  @GetMapping("/list")
  public AjaxResult list(SchoolLabClassYearVo schoolLabClassYearVo)
  {
    List<Map<String, Object>> labList = schoolLabClassYearService.getLabList(schoolLabClassYearVo);
    return AjaxResult.success(labList);
  }

  /**
   * 获取实验室详细信息
   */
  @GetMapping(value = "/{id}")
  public AjaxResult getInfo(@PathVariable("id") Long id)
  {
    return AjaxResult.success(schoolLabService.selectSchoolLabById(id));
  }

  /**
   * 新增实验室
   */
  @Log(title = "实验室", businessType = BusinessType.INSERT)
  @PostMapping("/add")
  public AjaxResult add(@RequestBody SchoolLab schoolLab)
  {
    return toAjax(schoolLabService.insertSchoolLab(schoolLab));
  }

  /**
   * 修改实验室
   */
  @Log(title = "实验室", businessType = BusinessType.UPDATE)
  @PutMapping("/edit")
  public AjaxResult edit(@RequestBody SchoolLab schoolLab)
  {
    return toAjax(schoolLabService.updateSchoolLab(schoolLab));
  }

  /**
   * 删除实验室
   */
  @Log(title = "实验室", businessType = BusinessType.DELETE)
  @PostMapping("/{ids}")
  public AjaxResult remove(@PathVariable Long[] ids)
  {
    return toAjax(schoolLabService.deleteSchoolLabByIds(ids));
  }

  /**
   * 获取实验室负责人下拉框
   * @return
   */
  @GetMapping("/getLabAdmin")
  public AjaxResult getLabAdmin(){
    return AjaxResult.success(schoolLabService.getLabAdmin());
  }

  /**
   * 实验室管理员-获取学科下拉框
   * @return
   */
  @GetMapping("/getSub")
  public AjaxResult getSub(){
    return AjaxResult.success(schoolLabService.getSub());
  }
}
