package yangtz.cs.liu.wechat.controller.courseSelection;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.AjaxResult;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.curricula.CurriclaStudentVo;
import yangtz.cs.liu.campus.domain.curricula.CurriculaStudent;
import yangtz.cs.liu.campus.domain.curricula.CurriculaVariable;
import yangtz.cs.liu.campus.service.curricula.ICurriculaStudentService;
import yangtz.cs.liu.campus.service.curricula.ICurriculaVariableService;
import yangtz.cs.liu.campus.service.curricula.IStudentScoreService;
import yangtz.cs.liu.campus.vo.student.SchoolStudentScoreVo;

/**
 * 公众号，选课
 */
@RestController
@RequestMapping("/wx/course")
public class WxCouresSelection {

  @Autowired
  IStudentScoreService iStudentScoreService;

  @Autowired
  ICurriculaStudentService iCurriculaStudentService;

  @Autowired
  ICurriculaVariableService iCurriculaVariableService;

  /**
   * 学生选课信息查询
   */
  @GetMapping("/getCourseInfo/{studentId}")
  private AjaxResult getCourseInfo(@PathVariable("studentId") Long studentId) {
    List<CurriclaStudentVo> CurriclaStudentVoList = new ArrayList<>();
    //查询学生个人选课信息
    LambdaQueryWrapper<CurriculaStudent> wrapper = new LambdaQueryWrapper<>();
    wrapper.eq(CurriculaStudent::getStudentId, studentId);
    wrapper.eq(CurriculaStudent::getDelFlag, "0");
    //查询出学生任务信息
    List<CurriculaStudent> list = iCurriculaStudentService.list(wrapper);
    //判断当前学生是否可以选课
    Boolean flag = false;
    CurriculaVariable byId = null;
    //1.是否有选课任务
    if (list.isEmpty()) {
      flag = true;
    }
    //是否在选课时间内
    if (!list.isEmpty()) {
      for (CurriculaStudent dates :list){
        byId = iCurriculaVariableService.getById(dates.getCurriculaId());
        //查询选课信息
        if (null == byId) {
          return AjaxResult.error("选课主题丢失，请联系管理员");
        }


        //设置当前时间
        Calendar date = Calendar.getInstance();
        date.setTime(new Date());
        //开始时间
        Calendar startDade = Calendar.getInstance();
        startDade.setTime(byId.getStartTime());
        //结束时间
        Calendar endDade = Calendar.getInstance();
        endDade.setTime(byId.getEndTime());
        //处于开始时间之后，和结束时间之前的判断
        if ((date.after(startDade) && date.before(endDade))) {
          flag = false;
        } else {
          flag = true;
        }
        //判断当前否结束选课
        if (date.after(endDade)){
          flag=true;
        }
      //判断当时时间是否选课之后
      CurriclaStudentVo data = new CurriclaStudentVo();
      //拼接返回对象
      BeanUtils.copyProperties(dates, data);
      BeanUtils.copyProperties(byId, data);
      data.setId(dates.getId());
      data.setFlag(flag);
      CurriclaStudentVoList.add(data);
      }
    }
      return AjaxResult.success(CurriclaStudentVoList);
    
  }

  /**
   * 学生选课信息查询
   */
  @GetMapping("/getStudenCoures/{id}")
  public AjaxResult getStudenCoures(@PathVariable("id") Long id){
    return AjaxResult.success(iCurriculaStudentService.getById(id));
  }

  /**
   * 学生选课课程展示
   */
  @GetMapping("/getCurriculaSub/{id}")
  public  AjaxResult getCurriculaSub(@PathVariable("id") Long id){
    return AjaxResult.success(iCurriculaVariableService.selectCurriculaVariableById(id));
  }

  /**
   * 学生成绩查询
   */
  @GetMapping("/achievement/{studentId}")
  private AjaxResult getStudentAchievements(@PathVariable("studentId") Long studentId){
    List<SchoolStudentScoreVo> schoolStudentScoreVos = iStudentScoreService
        .selectStudentScoreList(studentId);
    return AjaxResult.success(schoolStudentScoreVos);
  }

  /**
   * 据物理化类型查看
   */
  @GetMapping("/studenttypeview")
  private AjaxResult getStudentTypeview( CurriculaStudent curriculaStudent){
    List<SchoolStudentScoreVo> studentTypeViwe = iStudentScoreService
        .getStudentTypeViwe(curriculaStudent);
    return AjaxResult.success(studentTypeViwe);
  }


  /**
   * 保存选课信息
   */
  @PutMapping("/savestudentcourse")
  private AjaxResult saveStudentcourse(@RequestBody CurriculaStudent curriculaStudent){
    //保存专业信息
    try {
      boolean b = iCurriculaStudentService.saveOrUpdate(curriculaStudent);
      return AjaxResult.success("选课成功");
    }catch (Exception e){
      return AjaxResult.error("选课失败");
    }
  }

}
