package yangtz.cs.liu.wechat.controller.attendance;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolAtt.SchoolAtt;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherAttendance;
import yangtz.cs.liu.campus.service.schoolAtt.ISchoolAttService;
import yangtz.cs.liu.wechat.service.attendance.IAttendanceService;
import yangtz.cs.liu.wechat.vo.attendance.TeacherSignVO;
import yangtz.cs.liu.wechat.vo.attendance.TeacherAttendanceVO;

import java.util.Date;
import java.util.List;

import static com.ruoyi.common.utils.StringUtils.isNotNull;

/**
 * 老师考勤Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/teacherAttendance")
public class TeacherAttendanceController extends BaseController {

    @Autowired
    private IAttendanceService attendanceService;

    @Autowired
    private ISchoolAttService schoolAttService;


    /*
     * 获取出勤任务页面的显示，和出勤统计页面数据(先用不到)
     * */
    @GetMapping("/attendanceTask")
    public AjaxResult attendanceTask(TeacherAttendanceVO attendanceVO) {
        if (StringUtils.isNull(getUserId())) {
            return AjaxResult.error("用户未登录,请返回登录");
        }
        if (StringUtils.isNull(attendanceVO.getResearchTime())) {
            return AjaxResult.error("查询时间 ResearchTime 未传 例如 2022-10");
        }
        TeacherAttendanceVO attendanceDetails = attendanceService.getAttendanceTask(attendanceVO);
        return AjaxResult.success(attendanceDetails);
    }

    /*
     * 获取老师今日考勤页面
     * */
    @GetMapping("/getToDayAttendance")
    public AjaxResult toDayAttendance(SchoolTeacherAttendance attendance) {
        if (StringUtils.isNull(getUserId())) {
            return AjaxResult.error("用户未登录,请返回登录");
        }
        if (StringUtils.isNull(attendance.getAttendanceTime())) {
            return AjaxResult.error("未传出勤日期 2022-11-05 12：30：35");
        }
        attendance.setUserId(getUserId());
        TeacherSignVO teacherSign = attendanceService.getToDayAttendance(attendance);
        return AjaxResult.success(teacherSign);
    }


    /*
     * 获取历史出勤任务列表
     * */
    @GetMapping("/attendanceHistories")
    public AjaxResult attendanceHistories(TeacherAttendanceVO attendanceVO) {
        if (StringUtils.isNull(getUserId())) {
            return AjaxResult.error("用户未登录,请返回登录");
        }
        if (StringUtils.isNull(attendanceVO.getResearchTime())) {
            return AjaxResult.error("查询时间 ResearchTime 未传 例如 2022-10");
        }
        attendanceVO.setUserId(getUserId());
        List<SchoolTeacherAttendance> attendanceList = attendanceService.getAttendanceHistories(attendanceVO);
        return AjaxResult.success(attendanceList);
    }

    /*
     * 获取单个出勤详情
     * */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        return AjaxResult.success(attendanceService.getById(id));
    }

    /*
     * 早上签到
     * @param attendanceAmIn
     * @param teacherId
     * */
    @PutMapping("/moningComeSign")
    public AjaxResult moningComeSign(@RequestBody @Validated SchoolTeacherAttendance schoolTeacherAttendance) {
        if (StringUtils.isNull(schoolTeacherAttendance.getId())) {
            AjaxResult.error("考勤id未传");
        }
        return toAjax(attendanceService.updateById(schoolTeacherAttendance));

    }

    /*
     * 早上下班签到
     * @param attendanceAmOut
     * @param teacherId
     * */
    @PutMapping("/moningLeaveSign")
    public AjaxResult moningLeaveSign(@RequestBody @Validated SchoolTeacherAttendance schoolTeacherAttendance) {
        if (StringUtils.isNull(schoolTeacherAttendance.getId())) {
            AjaxResult.error("考勤id未传");
        }
        return toAjax(attendanceService.updateById(schoolTeacherAttendance));

    }

    /*
     * 下午下班签到
     * */
    @PutMapping("/afterComeSign")
    public AjaxResult afterComeSign(@RequestBody @Validated SchoolTeacherAttendance schoolTeacherAttendance) {
        if (StringUtils.isNull(schoolTeacherAttendance.getId())) {
            AjaxResult.error("考勤id未传");
        }
        return toAjax(attendanceService.updateById(schoolTeacherAttendance));

    }

    /*
     * 下午下班签到
     * */
    @PutMapping("/afterLeaveSign")
    public AjaxResult afterLeaveSign(@RequestBody @Validated SchoolTeacherAttendance schoolTeacherAttendance) {
        if (StringUtils.isNull(schoolTeacherAttendance.getId())) {
            AjaxResult.error("考勤id未传");
        }
        return toAjax(attendanceService.updateById(schoolTeacherAttendance));

    }

    /**
     * 获取某一天打卡细节
     * @param date
     * @return
     */
    @GetMapping("/getAttendance/{userId}")
    public TableDataInfo getAttendance(@PathVariable("userId") Long userId, String date){
        List<SchoolAtt> list = schoolAttService.getDetailsList(userId,date);
        return getDataTable(list);
    }

}
