package yangtz.cs.liu.wechat.controller.attendance;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.student.SchoolEducation;
import yangtz.cs.liu.wechat.service.attendance.IStudentAttendanceService;
import yangtz.cs.liu.wechat.vo.attendance.TeacherAttendanceVO;

/**
 * 学生德育Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/studentAttendance")
public class StudentAttendanceController extends BaseController {

    @Autowired
    private IStudentAttendanceService iStudentAttendanceService;

    /*
    * 学生德育
    * */
    @GetMapping("/getAttendance")
    public AjaxResult attendanceTask(SchoolEducation schoolEducation){
        if(StringUtils.isNull(schoolEducation.getStudentId())){
            return AjaxResult.error("学生id未传");
        }
        if(StringUtils.isNull(schoolEducation.getPatrolDate())) {
            return AjaxResult.error("日期未传 例如 2022-10-1");
        }

        return AjaxResult.success(iStudentAttendanceService.getAttendance(schoolEducation));
    }
    /*
    * 历史德育查看
    * */
    @GetMapping("/getAttendanceList")
    public AjaxResult attendanceList(SchoolEducation schoolEducation){
        if(StringUtils.isNull(schoolEducation.getStudentId())){
            return AjaxResult.error("学生id未传");
        }
        return AjaxResult.success(iStudentAttendanceService.getAttendanceList(schoolEducation));
    }


}
