package yangtz.cs.liu.wechat.controller.api;

import com.ruoyi.common.core.domain.AjaxResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.dingding.utils.DdConfigSign;
import yangtz.cs.liu.dingding.utils.DingUserUtils;
import yangtz.cs.liu.dingding.utils.JSAPIUtils;

/**
 * 鉴权
 */
@RestController
@RequestMapping("/wx/jsapi")
public class WxJsapiController {

    @Autowired
    private JSAPIUtils jsapiUtils;
    @Value("${dd.message-uri}")
    private String messageUri;
    @Value("${dd.agentId}")
    private String agentId;
    @Value("${dd.corpId}")
    private String corpId;


    /**
     * 鉴权
     * @return
     */
    @GetMapping("/jq")
    public AjaxResult jq(){
        AjaxResult ajaxResult = AjaxResult.success();
        //获取jsapi_ticket
        String jsapiTicket = jsapiUtils.getJsapiTicket();
        //自定义固定字符串
        String randomStr = DdConfigSign.getRandomStr(5);
        //时间戳
        long timestamp = System.currentTimeMillis();
        String sign = "";
        try {
            sign = DdConfigSign.sign(jsapiTicket, randomStr, timestamp, messageUri);
        } catch (Exception e) {
            e.printStackTrace();
        }
        ajaxResult.put("agentId",agentId);
        ajaxResult.put("corpId",corpId);
        ajaxResult.put("timeStamp",timestamp);
        ajaxResult.put("nonceStr",randomStr);
        ajaxResult.put("signature",sign);
        return ajaxResult;
    }
}
