package yangtz.cs.liu.webpage.vo;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import java.util.List;
import lombok.Data;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitStudentFamily;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitStudentFjb;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitStudentJl;

/**
 * @author xuten
 */
@Data
public class WebSchoolRecruitStudentVo extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /** 姓名 */
    @Excel(name = "姓名")
    private String studentName;

    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;

    /** 学籍号 */
    @Excel(name = "学籍号")
    private String studentNumber;

    /** 初中学校id */
    @Excel(name = "初中学校id")
    private Long juniorId;
    private String schoolName;

    /** 测试项目id */
    @Excel(name = "测试项目id")
    private Long testId;
    private String project;

    /** 性别（0=男，1=女） */
    @Excel(name = "性别", readConverterExp = "0==男，1=女")
    private String sex;

    /** 身高（单位厘米） */
    @Excel(name = "身高", readConverterExp = "单=位厘米")
    private double height;

    /** 体重（单位千克） */
    @Excel(name = "体重", readConverterExp = "单=位千克")
    private double weight;

    /** 联系方式1 */
    @Excel(name = "联系方式1")
    private String telephone1;

    /** 联系方式2 */
    @Excel(name = "联系方式2")
    private String telephone2;

    /** 照片 */
    @Excel(name = "照片")
    private String photo;
    //存放网页图片的base64 数据
    private String photoData;

    /** 手机号 */
    @Excel(name = "手机号")
    private String phoneNumber;

    /** 密码 */
    @Excel(name = "密码")
    private String password;

    private String auditStatus;
    private String backMessage;

    private List<SchoolRecruitStudentJl> resumeData;
    private List<SchoolRecruitStudentFamily> remeberData;
    private List<SchoolRecruitStudentFjb> fileList;


    private String mz;
    private String zzmm;
    private String csrq;
    private String hyzk;
    private String hjszd;
    private String syd;
    private String kssf;
    private String cjgzsj;
    private String xgzdwzw;
    private String bkxlsfqrz;
    private String xl;
    private String xw;
    private String byxx;
    private String sxzz;
    private String zhbysj;

}
