package yangtz.cs.liu.dingding.vo;

import lombok.Data;

/**
 * 部门管理
 */
@Data
public class DingSchoolDeptVo {

    /** 部门id */
    private Long deptId;

    /** 部门名称  长度限制为1~64个字符，不允许包含字符"-"","以及"," */
    private String name;

    /** 父部门ID，根部门ID为1 */
    private Long parentId;

    /** 是否隐藏部门 */
    private Boolean hideDept;

    /** 指定可以查看本部门的其他部门列表，总数不能超过50  当hide_dept为true时，则此值生效 */
    private String deptPermits;

    /** 指定可以查看本部门的人员userId列表，总数不能超过50  当hide_dept为true时，则此值生效 */
    private String userPermits;

    /** 是否限制本部门成员查看通讯录 */
    private Boolean outerDept;

    /** 本部门成员是否只能看到所在部门及下级部门通讯录  当outer_dept为true时，此参数生效 */
    private Boolean outerDeptOnlySelf;

    /** 指定本部门成员可查看的通讯录用户userId列表，总数不能超过50  当outer_dept为true时，此参数生效 */
    private String outerPermitUsers;

    /** 指定本部门成员可查看的通讯录部门ID列表，总数不能超过50  当outer_dept为true时，此参数生效 */
    private String outerPermitDepts;

    /** 是否创建一个关联此部门的企业群，默认为false即不创建 */
    private Boolean createDeptGroup;

    /** 是否默认同意加入该部门的申请 */
    private Boolean autoApproveApply;

    /** 在父部门中的排序值，order值小的排序靠前 */
    private Long order;

    /** 通讯录语言  zh_CN：中文  en_US：英文 */
    private String language;

    /** 当部门群已经创建后，有新人加入部门时是否会自动加入该群 */
    private Boolean autoAddUser;

    /** 部门的主管userId列表，多个userid之间使用英文逗号分隔 */
    private String deptManagerUseridList;

    /** 部门群是否包含子部门 */
    private Boolean groupContainSubDept;

    /** 部门群是否包含外包部门 */
    private Boolean groupContainOuterDept;

    /** 部门群是否包含隐藏部门 */
    private Boolean groupContainHiddenDept;

    /** 企业群群主的userId */
    private String orgDeptOwner;

    /** 强制更新的字段，支持清空指定的字段，多个字段之间使用英文逗号分隔。目前支持字段: dept_manager_userid_list */
    private String forceUpdateFields;

    /** 部门标识字段 */
    private String sourceIdentifier;

    /** 部门简介 */
    private String brief;

    /** 部门联系方式 */
    private String telephone;

    /** 扩展字段，JSON格式 */
    private String extension;
}
