package yangtz.cs.liu.dingding.vo;

import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.taobao.api.internal.util.json.JSONWriter;
import lombok.Data;

/**
 * 消息通知
 */
@Data
public class DingMessageVo {

    /** 发送消息时使用的微应用的AgentID */
    private Long agentId;

    /** 接收者的部门id列表，最大列表长度20  接收者是部门ID时，包括子部门下的所有用户 */
    private String deptIdList;

    /** 消息内容，最长不超过2048个字节  支持以下工作通知类型（文本消息,图片消息,语音消息,文件消息,链接消息,OA消息,Markdown消息,卡片消息） */
    private String msg;

    /** 是否发送给企业全部用户 */
    private Boolean toAllUser;

    /** 接收者的userid列表，最大用户列表长度100 */
    private String useridList;

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setMsg(OapiMessageCorpconversationAsyncsendV2Request.Msg msg) {
        this.msg = (new JSONWriter(false, false, true)).write(msg);
    }

    public String getMsg() {
        return this.msg;
    }
}
